package elaborator.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import elaborator.utils.FileLoader;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import elaborator.Receiver;

/**
 * Usa la stessa interfaccia Receiver per comunicare i dati all'Elaborator.
 * Mentre, stabilendo noi il formato dei dati nei file del database col
 * FileWriter non abbiamo bisogno di cautelarci con un Adapter (come invece per
 * i dati in arrivo dai sensori)
 * 
 * @author koelio
 * 
 */
public class FileLoader implements Receiver {

	private String filename;
	private int[] temps;
	private int diameter;
	private Map<Double, String> elements;

	public FileLoader(String filename){
		this.filename = filename;
		temps = new int[2];
		elements = new HashMap<Double, String>();
		
		try {

			BufferedReader reader = new BufferedReader(new java.io.FileReader(
					new File("database/"+filename+".txt")));

			String line = reader.readLine();

			StringTokenizer tok = new StringTokenizer(line);
			
			this.temps[0] = Integer.parseInt(tok.nextToken());
			this.temps[1] = Integer.parseInt(tok.nextToken());

			line = reader.readLine();
			
			this.diameter = Integer.parseInt(line);
			
			line = reader.readLine();
			//System.out.println("\n"+line);
			while (line != null) {

				StringTokenizer tok2 = new StringTokenizer(line);
				elements.put(Double.parseDouble(tok2.nextToken()),
						tok2.nextToken());
				line = reader.readLine();

			}

			reader.close();

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
//	public void getPlanet(String filename) {
//
//	}

	@Override
	public int[] getTemps() {
		return this.temps;
	}

	@Override
	public int getDiameter() {
		return this.diameter;
	}

	@Override
	public Map<Double, String> getComposition() {
		return this.elements;
	}

	@Override
	public String getPlanetName() {
		return this.filename;
	}

}
